<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductArchiveTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_archive', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('product_id');
            $table->year('fy');
            $table->integer('ptype')->default(1);
            $table->string('barcode');
            $table->string('code');
            $table->string('name');
            $table->double('price', 10, 2)->nullable();
            $table->double('purchase', 10, 2)->nullable();
            $table->integer('outlet_id')->nullable();
            $table->string('outlet_name')->nullable();
            $table->integer('supplier_id');
            $table->string('supplier_name');
            $table->string('entry_statement');
            $table->json('transfer')->nullable();
            $table->string('transfer_statement');
            $table->json('sell')->nullable();
            $table->string('sell_statement');
            $table->json('return')->nullable();
            $table->integer('status')->default(1);

            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_archive');
    }
}
