<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSellTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sell', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->year('fy');
            $table->string('date');
            $table->string('order_no');
            $table->string('invoice_no');
            $table->string('returninvoice');
            $table->integer('outlet');
            $table->integer('customer');
            $table->float('amount');
            $table->float('discount');
            $table->float('vat');
            $table->float('payable');
            $table->float('paid');
            $table->float('paid2');
            $table->float('paid3');
            $table->float('due');
            $table->integer('payment_method');
            $table->integer('payment_method2');
            $table->integer('payment_method3');
            $table->json('items');
            $table->json('screen_data');
            $table->enum('status', ['0', '1','2']);
            

            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sell');
    }
}
