<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStockTransferTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_transfer', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('transfer_code');
            $table->year('fy');
            $table->integer('transfer_from');
            $table->string('from_name');
            $table->integer('transfer_to');
            $table->string('to_name');
            $table->json('items');
            $table->enum('status', ['0', '1','2']);
            $table->integer('initiated_by');
            $table->string('initiated_name');
            $table->date('initiated_date');
            $table->integer('confirmed_by');
            $table->string('confirmed_name');
            $table->date('confirmed_date');
            

            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_transfer');
    }
}
