<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code');
            $table->string('name');
            $table->mediumText('description');
            $table->integer('e_variation')->default(0);
            $table->integer('category');
            $table->integer('size');
            $table->string('photo');
            $table->string('photo1');
            $table->string('photo2');
            $table->integer('selling_price');
            $table->integer('color_id');
            $table->string('color');
            $table->string('age_range');
            $table->integer('discount');
            $table->string('fabric');
            $table->string('measurement');
            $table->enum('active', ['yes', 'no']);
            $table->integer('current_stock')->default(0);
            $table->enum('ecommerce', ['yes', 'no'])->default('no');
            $table->integer('e_id')->default(0);
            $table->string('e_code')->default('0');
            //$table->json('e_api');
            $table->timestamp('last_synched');

            //$table->string('barcode');


            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
