<?php

namespace App\Providers;

use App\Events\StockIsZeroEvent;
use App\Events\PathaoHookReceivedEvent;
use App\Events\ProductAddedEvent;
use App\Events\ProductUpdatedEvent;
use App\Events\StockGlobalRecalculate;
use App\Events\StockUpdateEvent;
use App\Listeners\Daraz\StockUpdateForDaraz;
use App\Listeners\PathaoHookOrderProcess;
use App\Listeners\RemoveVariationFromEcommerceListner;
use App\Listeners\Ecommerce\ProductAddForEcommerce;
use App\Listeners\Ecommerce\ProductUpdateForEcommerce;
use App\Listeners\Ecommerce\StockUpdateForEcommerce;
use App\Listeners\ProductAddForDaraz;
use App\Listeners\ProductAddForAadi;
use App\Listeners\Utility\StockGlobalRecalculate as UtilityStockGlobalRecalculate;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        StockIsZeroEvent::class => [
            RemoveVariationFromEcommerceListner::class,
        ],
        PathaoHookReceivedEvent::class =>[
            PathaoHookOrderProcess::class
        ],
        ProductAddedEvent::class => [
            ProductAddForEcommerce::class,
            //ProductAddForDaraz::class,
            //ProductAddForAadi::class,
        ],
        ProductUpdatedEvent::class => [
            ProductUpdateForEcommerce::class,
        ],
        StockUpdateEvent::class =>[
            StockUpdateForEcommerce::class,
            StockUpdateForDaraz::class,
        ],
        StockGlobalRecalculate::class =>[
            UtilityStockGlobalRecalculate::class
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
