<?php

namespace App\Models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class SupplierBillPay extends Model
{
    protected $table = 'supplier_bill_pay';
    public $timestamps = false;

    protected $fillable = array('supplier','outlet','entry_by');

    public function supplier(){
        return $this->belongsTo(Supplier::class, 'supplier','id');
    }

    public function outlet(){
        return $this->belongsTo(Outlet::class, 'outlet','id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'entry_by','id');
    }
}
