<?php

namespace App\Models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class P_Loan extends Model
{
    protected $table = 'p_loans';
    public $timestamps = false;

    protected $fillable = array('emp_id','outlet','entry_by');

    public function employee(){
        return $this->belongsTo(P_Employee::class, 'emp_id','id');
    }

    public function outlet(){
        return $this->belongsTo(Outlet::class, 'outlet','id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'entry_by','id');
    }
}
