<?php

namespace App\Models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    protected $table = 'expense';
    public $timestamps = false;
    protected $fillable = array('expense_sector','outlet','method','approved_by','entry_by');
    
    public function sector(){
        return $this->belongsTo(Expense_sector::class, 'expense_sector','id');
    }
    public function outlet(){
        return $this->belongsTo(Outlet::class, 'outlet','id');
    }
    public function method(){
        return $this->belongsTo(Balance_method::class, 'method','id');
    }
    public function entry_by(){
        return $this->belongsTo(User::class, 'entry_by','id');
    }
    public function approved_by(){
        return $this->belongsTo(User::class, 'approved_by','id');
    }
}
