<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;

class BalanceWithdraw extends Model
{
    protected $table = 'balance_withdraws';
    public $timestamps = false;
    protected $fillable = array('from_method','outlet','entry_by');

    public function method(){
        return $this->belongsTo(Balance_method::class, 'from_method','id');
    }

    public function outlet(){
        return $this->belongsTo(Outlet::class, 'outlet','id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'entry_by','id');
    }
}