<?php

namespace App\Models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class BalanceTransfer extends Model
{
    protected $table = 'balance_transfers';
    public $timestamps = false;
    protected $fillable = array('from_method','from_outlet','entry_by','to_method','to_outlet','received_by');

    public function method(){
        return $this->belongsTo(Balance_method::class, 'from_method','id');
    }

    public function r_method(){
        return $this->belongsTo(Balance_method::class, 'to_method','id');
    }

    public function outlet(){
        return $this->belongsTo(Outlet::class, 'from_outlet','id');
    }

    public function to_outlet(){
        return $this->belongsTo(Outlet::class, 'to_outlet','id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'entry_by','id');
    }

    public function r_user(){
        return $this->belongsTo(User::class, 'received_by','id');
    }
}