<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Balance extends Model
{
    protected $table = 'balance';
    protected $casts = [
        'outlet'=>'integer',
        'amount'=>'double',
        'balance_method'=>'integer',
    ];
    public $timestamps = false;
    protected $fillable = array('balance_method','outlet');
    
    public function outlet(){
        return $this->belongsTo(Outlet::class, 'outlet','id');
    }
    public function method(){
        return $this->belongsTo(Balance_method::class, 'balance_method','id');
    }
}