<?php

namespace App\Listeners\Ecommerce;

use Illuminate\Contracts\Queue\ShouldQueue;
use Automattic\WooCommerce\Client;
use App\Models\Product;
use App\Models\Productarchive;

class StockUpdateForEcommerce implements ShouldQueue
{   public $delay = 0;
    public $tries = 5;
    //public $timeout = 900;
    
    public function handle($event)
    {
        $url = config('woocommerce.store_url');
        $key = config('woocommerce.consumer_key');
        $secret = config('woocommerce.consumer_secret');
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => false];
        $client = new Client($url,$key,$secret, $version);
        $v_code = $event->code; // Variatio Code Given
        $code = '';
        //Variation code to base code
        $arr = explode('-',$v_code);
        $l = count($arr) -2;
        for($i=0;$i<=$l;$i++){
            if($i==$l)$code.=$arr[$i];
            else $code.=$arr[$i].'-';
        }
        $ecom_products = $client->get('products',['sku'=>$code]);
        if(isset($ecom_products[0])){
            $ecom_vars = $client->get('products/'.$ecom_products[0]->id.'/variations');
            foreach ($ecom_vars as $key => $variation) {
                $client->delete('products/'.$ecom_products[0]->id.'/variations/'.$variation->id, ['force' => true]);
            }
            $size_options = $ecom_products[0]->attributes[0]->options;
            $variations = [];
            $barcodes = Productarchive::where('code','LIKE',$code.'-%')->where('status','=',3)->groupBy('code')->get(['code']);
            // Generate New Variations
            foreach ($barcodes as $key => $item) {
                $product = Product::where('code',$item->code)->first();
                if(!in_array($product->getsize->age_range,$size_options)){
                    array_push($size_options,$product->getsize->age_range);
                }
                $v['var_data'] = [
                    'sku' => $product->code,
                    'regular_price' => "$product->selling_price",
                    'manage_stock' => false,
                    'stock_quantity' => null,
                    'stock_status' => 'instock',
                    'attributes'    => [
                        [
                            'id'     => 2,
                            'option' => $product->getsize->age_range,
                        ],
                    ],
                ];
                array_push($variations,$v);
            }
            //Prepare product attributes for new variations
            $attributes = [
                [
                    'id' => 2,
                    'name' => "Baby's Age",
                    'position' => 1,
                    'visible' => true,
                    'variation' => true,
                    'options' => $size_options
                ]
            ];
            $data = [
                "attributes" => $attributes,
            ];
            //Update product attributes
            $client->put('products/'.$ecom_products[0]->id, $data);
            // Create Existing Variations
            foreach ($variations as $key=>$var) {
                $client->post('products/'.$ecom_products[0]->id.'/variations', $var['var_data']);
            }
        }
        
    }
    
}
