<?php

namespace App\Http\Controllers\api\v1\order;

use App\Events\StockUpdateEvent;
use App\Events\PathaoHookReceivedEvent;
use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Exchange;
use App\Models\Expense;
use Illuminate\Http\Request;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelHigh;
use Endroid\QrCode\Label\Alignment\LabelAlignmentCenter;
use Endroid\QrCode\Label\Font\NotoSans;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;
 
use Carbon\Carbon;

use App\Models\Order;
use App\Models\OrderTransfer;
use App\Models\Outlet;
use App\Models\Payment;
use App\Models\Productarchive;
use App\Models\OrderLog;
use App\Models\Packaging;
use App\Models\Shipment;
use App\Models\Balance_transection;
use App\Models\Balance;
use App\User;
use PDF;

use Codeboxr\PathaoCourier\Facade\PathaoCourier;
use Illuminate\Support\Arr;

class OrderController extends Controller
{
    private function getNewTransectionno($outlet){
        $today = date("Y-m-d");
        $test_inv = $today.'-'.$outlet;
        $statements = Balance_transection::where('transection_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    
    private function getNewPaymentno($outlet){
        $today = date("Y-m-d");
        $test_inv = 'P-'.$today.'-'.$outlet;
        $statements = Payment::where('payment_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    
    public function insertOrderLog($order_no,$event,$message){
        $parts = explode('-', $order_no);
        $log = new OrderLog();
        $log->order_no = $order_no;
        //$log->tracking_no = $tracking_no;
        $log->outlet = (int)$parts[4];
        $log->event = $event;
        $log->message = $message;
        $log->entry_by = Auth::user()->id;
        $log->save();
    }
    
    private function insertHookOrderLog($order_no,$event,$message){
        $parts = explode('-', $order_no);
        $log = new OrderLog();
        $log->order_no = $order_no;
        $log->outlet = (int)$parts[4];
        $log->event = $event;
        $log->message = $message;
        $log->entry_by = 0;
        $log->save();
    }

    public function productShipped(Request $r){
        DB::transaction(function () use ($r) {
            DB::table('orders')
                    ->where('order_no',$r['order_no'])
                    ->update(['status'=>'Shipped','update_by'=>Auth::user()->id]);
            // Log Inserted From Delivery Controller
            //$this->insertOrderLog($r['order_no'],'Packaged','Order Packaged By '.Auth::user()->username);
        });
    }

    

    public function makeDelivered(Request $r){
        $ret = DB::transaction(function () use ($r) {

            DB::table('orders')
                    ->where('order_no',$r['order_no'])
                    ->update(['status'=>'Delivered','delivered_at'=>Carbon::now()->toDateTimeString(),'update_by'=>Auth::user()->id]);

            $pack = Packaging::where('order_no',$r['order_no'])->orderBy('entry_at','desc')->first();
            $pack->status = 'Delivered';
            $pack->approval_waiting = '';
            $pack->update_by = Auth::user()->id;
            $pack->save();

            $exchange =  Exchange::where('order_no','=', $r['order_no'])->where('status','=','Initiated')
            ->first();
            if($exchange === null){

            }
            else{
                $exchange->status = 'Delivered';
                $exchange->save();
                foreach ($exchange->items[0]['returned'] as $key => $value) {

                    DB::table('product_archive')
                    ->where('id',$value['barcode_id'])
                    ->update(['status'=>3,'update_by'=>Auth::user()->id]);
                }

            }
            

            $ship = Shipment::where('order_no',$r['order_no'])->orderBy('entry_at','desc')->first();
            if($ship!=null){
                $ship->status = 'Completed';
                $ship->approval_waiting = '';
                $ship->update_by = Auth::user()->id;
                $ship->save();
            }

        
            $this->insertOrderLog($r['order_no'],'Delivered','Packet '.$pack->packet_no.' Delivered By '.Auth::user()->username);
            return [
                'status'=>'success',
                'title'=>'Delivered',
                "message" => 'Order Successfully Delivered',
            ];
        });
        return $ret;
    }

    public function makeExchanged(Request $r){
        DB::transaction(function () use ($r) {
            $exchange = new Exchange();
            $exchange->exchange_no = $this->getExchangeNo();
            $exchange->order_no = $r['order_no'];
            $exchange->items = $r['exchanges'];
            $exchange->delivery_channel = $r['delivery_channel']['id'];
            $exchange->delivery_fee = $r['delivery_channel']['rate'];
            $exchange->status = 'Initiated';
            $exchange->entry_by = Auth::user()->id;
            $exchange->save();

            // DB::table('exchanges')
            //         ->where('exchange_no',$r['exchange_no'])
            //         ->update(['status'=>'Pending','update_by'=>Auth::user()->id]);
        
            $this->insertOrderLog($r['order_no'],'Exchange Initiated','Exchange No #'.$exchange->exchange_no.' Initiated By '.Auth::user()->username);
        });
    }

    public function makePending(Request $r){
        DB::transaction(function () use ($r) {
            $exchange =  Exchange::where('order_no','=', $r['order_no'])->where('status','=','Initiated')
            ->first();
            if($exchange===null){
                $order = Order::where('order_no',$r['order_no'])->first();
                $order->status = 'Pending';
                $order->update_by = Auth::user()->id;
                $order->save();
                $this->insertOrderLog($r['order_no'],'Pending','Order Status Changed By '.Auth::user()->username);
            
            }
            else{
                $exchange->status = 'Discarded';
                $exchange->save();

                $this->insertOrderLog($r['order_no'],'Exchange Discarded','Exchange No #'.$exchange->exchange_no.' Discarded By '.Auth::user()->username);
                $order = Order::where('order_no',$r['order_no'])->first();
                $order->status = 'Pending';
                $order->update_by = Auth::user()->id;
                $order->delivery_fee = ($order->delivery_fee - $exchange->delivery_fee);
                $order->save();
                $this->insertOrderLog($r['order_no'],'Pending','Order Status Changed By '.Auth::user()->username);
           
            }
            


        });
    }
    public function makeConfirmed(Request $r){
        return DB::transaction(function () use ($r) {
            DB::table('orders')
                    ->where('order_no',$r['order_no'])
                    ->update(['status'=>'Confirmed','update_by'=>Auth::user()->id]);
        
            $this->insertOrderLog($r['order_no'],'Confirmed','Order Status Changed By '.Auth::user()->username);

            $order = Order::with('delivery_channel')->with('outlet')->with('customer')->where('order_no',$r['order_no'])->first()->toArray();
            
            
            // if($order['delivery_channel']['pathao']==1 && isset($r['pathao_pickup'])){
            //     if($order['pathao_consignment_id']=='0' ){
            //         //Order::where('order_no',$r['order_no'])->update(['pathao_pickup'=>$r['pathao_pickup']]); 
            //         $outlt = Outlet::find($r['pathao_pickup']);
            //         $pathao =  PathaoCourier::order()
            //         ->create([
            //             "store_id"            => $outlt->pathao_store_id, // Find in store list,
            //             "merchant_order_id"   => $order['order_no'], // Unique order id
            //             "recipient_name"      => $order['customer']['name'], // Customer name
            //             "recipient_phone"     => $order['customer']['mobile'], // Customer phone
            //             "recipient_address"   => $order['customer']['deliveryaddress'], // Customer address
            //             "delivery_type"       => "48", // 48 for normal delivery or 12 for on demand delivery
            //             "item_type"           => "2", // 1 for document, 2 for parcel
            //             "special_instruction" => $order['remarks'],
            //             "item_quantity"       => count($order['items']), // item quantity
            //             "item_weight"         => "0.5", // parcel weight
            //             "amount_to_collect"   => $order['net_payable'], // amount to collect
            //             "item_description"    => collect($order['items'])->map(function ($item) {
            //                                         return "#{$item['barcode']}, {$item['name']} : {$item['price']}/-";
            //                                     })->implode(PHP_EOL) // product details
            //         ]);
                    
            //         if(isset($pathao->consignment_id)){
            //             $this->insertOrderLog($order['order_no'],'Pathao',$pathao->consignment_id);
            //             $this->insertOrderLog($order['order_no'],'Pathao Initiated','Pathao Initiated with consignment_id #'.$pathao->consignment_id.' Initiated By '.Auth::user()->username);
            //             Order::where('order_no',$order['order_no'])->update(['pathao_consignment_id'=>$pathao->consignment_id]);
            //         }
            //     }
            // }
            

            $ret = 'Order Successfully Confirmed Without Sending SMS';
            if($r['sms']=='yes'){
                $ret = Http::asForm()->post('http://api.greenweb.com.bd/api.php', [
                    'token' => '23ad51465250a1351b745f9e46a8b744',
                    'to' => '+88'.$order['mobile'],
                    'message' => '"দিগন্ত" বাচ্চাদের পোশাক। আপনার পণ্য এই ইনভয়েসের '
                    .$order['order_no'].' মাধ্যমে নিশ্চিত করা হয়েছে। বিলঃ '
                    .$order['net_payable'].'/-, পরিশোধিতঃ '
                    .$order['paid'].'/-, বকেয়াঃ '.($order['net_payable'] -$order['paid']).'/-। দিগন্তের সাথে থাকার জন্য ধন্যবাদ। হটলাইনঃ +8809610100040'
                ]);
            }
            
            
            return $ret;
            // return  Http::post('http://api.greenweb.com.bd/api.php', [
            //     'token' => '23ad51465250a1351b745f9e46a8b744',
            //     'to' => '+8801791767175',
            //     'message' => 'আপনার অর্ডার '.$order->order_no.' নিশ্চিত করা হয়েছে। বিলঃ '.$order->net_payable.'/-, পরিশোধিতঃ '.$order->paid.'/-, বকেয়াঃ '.($order->net_payable - $order->paid).'/-। দিগন্তের সাথে থাকার জন্য ধন্যবাদ।'
            // ]);
        });
    }

    public function makeCompleted(Request $r){
        DB::transaction(function () use ($r) {
            DB::table('orders')
                    ->where('order_no',$r['order_no'])
                    ->update(['status'=>'Completed','update_by'=>Auth::user()->id]);
        
            $this->insertOrderLog($r['order_no'],'Completed','Order Status Changed By '.Auth::user()->username);
        });
    }
    private function _checkCancalable(Request $r){
        return [
            'status'=>'success',
            'title'=>'ok',
            "message" => 'ok',
        ];
    }
    
    private function pathaoHookPayment($r){
        $ret = DB::transaction(function () use ($r) {
            $balance_amount = 0;
            $balance_method = 0;
            $type = $r['type'];
            // Cash/Partial Cash
            if($r['paymentmethod']['id']==1 || $r['paymentmethod']['id']==2){
                $balance_amount = floatval($r['amount']);
                $balance_method = 1;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }
            //City Amex, Bkash, UCB, UKash
            else if($r['paymentmethod']['id']==4 || $r['paymentmethod']['id']==6 || $r['paymentmethod']['id']==9 || $r['paymentmethod']['id']==11){
                $balance_amount = floatval($r['amount']);
                $balance_method = 2;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }
            //DBBL, Rocket, Nexus
            else if($r['paymentmethod']['id']==5 || $r['paymentmethod']['id']==7 || $r['paymentmethod']['id']==10){
                $balance_amount = floatval($r['amount']);
                $balance_method = 3;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }

            //Common Transection Log
            $transection_no = $this->getNewTransectionno($r['outlet']);    
            $transaction = new Balance_transection();
            $transaction->fy = date("Y");
            $transaction->date = date("Y-m-d");
            $transaction->transection_no = $transection_no;
            $transaction->outlet = (int)$r['outlet'];
            $transaction->amount = $balance_amount;
            $transaction->order_no = $r['order_no'];
            $transaction->balance_method = $balance_method;
            $transaction->type = $type;
            $transaction->entry_by = 0;
            $transaction->save();

            $payment_no = $this->getNewPaymentno($r['outlet']);
            $paymnt = new Payment();
            $paymnt->fy = date("Y");
            $paymnt->date = date("Y-m-d");
            $paymnt->balance_tran_no = $transection_no;
            $paymnt->payment_no = $payment_no;
            $paymnt->outlet = (int)$r['outlet'];
            $paymnt->amount = $balance_amount;
            $paymnt->order_no = $r['order_no'];
            $paymnt->balance_method = $balance_method;
            $paymnt->payment_method = (int) $r['paymentmethod']['id'];
            $paymnt->type = $type;
            $paymnt->entry_by = 0;
            $paymnt->save();

            $this->insertHookOrderLog($r['order_no'],'Payment','Payment '.$payment_no.' Amount '.$paymnt->amount.'/- Via '.$r['paymentmethod']['name'].' Entry By --AUTOMATIC');

            Order::where(['order_no' => $r['order_no']])->increment('paid', $balance_amount);
        });
        return ['ok'];

    }
    
    private function pathaoHookExpense($r){

        DB::transaction(function () use ($r) {
            //Order Info
            $order = Order::where('order_no',$r['order_no'])->first();
            $outlet = $order->outlet;
            $balance = Balance::where('outlet',$outlet)->where('balance_method',1)->first();
            
            //Expense status
            $expense = new Expense();
            $expense->expense_sector = 19; //order expense
            $expense->outlet = $outlet;
            $expense->method = 1;
            $expense->status = 'Pending';
            $expense->receipt_no = $r['order_no'];
            $expense->from_balance = $balance->id;
            $expense->amount = $r['amount'];
            $expense->remarks = 'Expense of '.$r['order_no'].' -- '.$r['remarks'];
            $expense->entry_by = 0;
            $expense->save();

            //decrement from balance
            $balance->decrement('amount',$r['amount']);
            $balance->save();
            //To frozen balance
            $to_frozen = Balance::where('outlet',$outlet)->where('balance_method',5)->first();
            $to_frozen->increment('amount',$r['amount']);
            $to_frozen->save();
        });
    }
    
    public function pathaoHook(Request $r){
        
        //event(new PathaoHookReceivedEvent($r->all()));
        $d['r'] = $r->all();
        event(new PathaoHookReceivedEvent($d['r']));
        //$order_no = $r['merchant_order_id'];
        // $order_no = 'ORD-2024-12-03-6-3';
        // $this->insertHookOrderLog($order_no,'Pathao_Hook',json_encode($r->all()));
        

        // $common = ['consignment_id','merchant_order_id','order_status','order_status_slug','updated_at','timestamp','store_id','payment_status','invoice_id'];
        // if(isset($r['order_status_slug'])){ // All about order
        //     $res = Arr::except($r->toArray(), $common);
        //     $msg = $r['order_status'];
        //     if(count($res)>0){
        //         $msg = json_encode($res);
        //     }
        //     $this->insertHookOrderLog($order_no,'Pathao_Hook',$msg);
        // }
        // else if(isset($r['payment_status'])){ // All about payment
        
        //     $this->insertHookOrderLog($order_no,'Pathao_'.$r['payment_status'],'Pathao Payment Hook Received');
        //     if($r['payment_status']=='Paid'){
        //         $pathao = PathaoCourier::order()->orderDetails($r['consignment_id']);
        //         // Add and remove cost from cash balance
        //         $parts = explode('-', $order_no);
    
        //         $arr['order_no'] = $order_no;
        //         $arr['amount'] = $pathao->total_fee;
        //         $arr['type'] = 1; // add first then remove
        //         $arr['outlet'] = (int)$parts[4];
        //         $arr['paymentmethod']['id'] = 1; // Cash balance
        //         $arr['paymentmethod']['name'] = 'Cash';
        //         // Add to cash balance
        //         $arr['remarks'] = 'Automatic Expense added from Pathao Hook for Patho-Payment-ID #'.$r['invoice_id'];
        //         $this->pathaoHookPayment($arr);
                
                
        //         // add expense
                
        //         $this->pathaoHookExpense($arr);
        //         // $arr['amount'] = - $pathao->total_fee;
        //         // $arr['type'] = -1; // remove
        //         // $arr['paymentmethod']['id'] = 1; // Cash balance
        //         // // Remove from cash balance
        //         // $this->pathaoHookPayment($arr);
                
        //         // Add others to City Amex
        //         $arr['amount'] = $pathao->order_amount - $pathao->total_fee;
        //         $arr['type'] = 1; // add to city
        //         $arr['paymentmethod']['id'] = 6; // City Amex
        //         $arr['paymentmethod']['name'] = 'City Amex';
        //         // Add rest to city balance
        //         $this->pathaoHookPayment($arr);
                
        //     }
        // }
        // else{ // Rest Others
        //     $res = Arr::except($r->toArray(), $common);
        //     if(count($res)>0){
        //         $msg = json_encode($res);
        //     }
        //     $this->insertHookOrderLog($order_no,'Pathao_UPDATE',$msg);
        // }
    }
    
    public function makeCanceled(Request $r){
        $ret = DB::transaction(function () use ($r) {
            // $ret =  [
            //             'status'=>'error',
            //             'title'=>'Impossible Cancel',
            //             "message" => 'You can not cancel this order',
            //         ];
            // if($ret['status']=='error') return $ret;
            // else{
                // Cancel All Transfers
                $transfers = OrderTransfer::where('order_no',$r['order_no'])->where('status','!=',3)->get();
                foreach ($transfers as $i => $itm) {
                    $o = Outlet::where('id',$itm->request_outlet)->first();
                    $outlet_id = $o->id;
                    $outlet_name = $o->name;
                    $barcode = $itm->barcode_init;
                    if($itm->status > 1){
                        $outlet = Outlet::where('id',$itm->seller_outlet)->first();
                        $outlet_id = $outlet->id;
                        $outlet_name = $outlet->name;
                        $barcode = $itm->barcode_final;
                    }
                    $archive = Productarchive::firstWhere('barcode',$barcode);
                    $archive->outlet_id = $outlet_id;
                    $archive->outlet_name = $outlet_name;
                    $archive->status = 3;
                    $archive->save();

                    // Action To Order Transfer Table
                    $transf = OrderTransfer::find($itm->id);
                    $transf->status = 4;
                    $transf->save();
                }

                // Remove All Item From Itemlist (Make Items Sellable)
                $order = Order::firstWhere('order_no',$r['order_no']);
                if($order->items != null){
                    foreach ($order->items as $i => $itm) {
                        $arch = Productarchive::firstWhere('barcode',$itm['barcode']);
                        $arch->status = 3;
                        $arch->save();
                    }
                }
                

                // Discard All Packets
                Packaging::where('order_no',$r['order_no'])
                        ->update(['status'=>'Discard']);
                
                // Order Table 
                DB::table('orders')
                ->where('order_no',$r['order_no'])
                ->update(['status'=>'Canceled','update_by'=>Auth::user()->id]);
                // Order Log
                $this->insertOrderLog($r['order_no'],'Canceled','Order Status Changed By '.Auth::user()->username);

                return [
                    'status'=>'success',
                    'title'=>'Order Canceled',
                    "message" => 'Order Cancel Successful By '.Auth::user()->username,
                ];
            //}

        });
        return $ret;
    }
    
    public function getOrder($order){
        $o = Order::with('delivery_channel')->with('pathao_pickup')->where('order_no','=', $order)->orderBy('entry_at','desc')->get();
        $ret['order_info'] = $o;
        $ret['transfer_info'] = OrderTransfer::where('order_no','=', $order)->orderBy('entry_at','desc')->get();
        $ret['payment_info'] = Payment::where('order_no','=', $order)->orderBy('entry_at','desc')->get();
        $ret['customer_info'] = Customer::where('id','=', $ret['order_info'][0]->customer)->get();
        $ret['log_info'] = OrderLog::where('order_no','=', $order)->orderBy('entry_at', 'desc')->get();
        $ret['packet_info'] = Packaging::where('order_no','=', $order)->orderBy('entry_at', 'desc')->get();
        $ret['shipment_info'] = Shipment::where('order_no','=', $order)->orderBy('entry_at', 'desc')->get();
        $ret['expense_info'] = Expense::where('receipt_no','=', $order)->orderBy('entry_at', 'desc')->get();
        $ret['exchange_info'] = Exchange::where('order_no','=', $order)
            ->with([
                'delivery_channel'=> function($query) {
                    $query->select('id','name','rate');
                },  
            ])->orderBy('entry_at', 'desc')->get();
        $ret['pathao_info'] = PathaoCourier::order()->orderDetails($o->first()->pathao_consignment_id);
            
        return $ret;
    }

    public function getAllOrdersOfLastMonth(){
        return Order::where([['status','!=','Completed']])->orderBy('entry_at', 'desc')->get();
    }
    public function init($outlet,$customer){
        
        //Customer::
        $c = (int) $customer;
        $order_no = $this->getOrderNo($outlet); // Collect New Order No.
        $order = new Order();
        $order->fy = date("Y");
        $order->date = date("Y-m-d");
        $order->outlet = (int)$outlet;
        $order->customer = (int)$c;
        $order->mobile = Customer::find($c)->mobile;
        $order->order_no = $order_no;
        $order->status = 'Pending';
        $order->entry_by = Auth::user()->id;
        $order->save(); // Order Entry
        ////
        $ret['id'] = $order->id;
        $ret['order_no'] = $order->order_no;

        //Order Log
        $this->insertOrderLog($order->order_no,'Created','New Order #'.$order->order_no.' Created By '.Auth::user()->username);
        return $ret;
        //$qrcode = new Generator;
        //$qrcode->size(500)->generate('Make a qrcode without Laravel!');
        ////

    }

    public function getOrderNo($outlet){
        $today = date("Y-m-d");
        $test_inv = 'ORD-'.$today.'-'.$outlet;
        $statements = Order::where('order_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }

    public function getExchangeNo(){
        $today = date("Y-m-d");
        $test_inv = 'EXCH-'.$today;
        $statements = Exchange::where('exchange_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }

    public function deleteitem(Request $r){
        DB::transaction(function () use ($r) {
            // Order Transfer Table
            $transfer = OrderTransfer::where(['status'=>1,'order_no'=>$r['orderno'],'barcode_init'=>$r['barcode']])->first();
            if ($transfer === null) { // Transfer Not Found

                $ownProduct = Productarchive::where(['id'=>$r['barcode_id'],'outlet_id'=>$r['outlet_id']])->first();
                if($ownProduct === null){ // His His ~ Whos Whos
                    DB::table('product_archive')
                    ->where('id',$r['barcode_id'])
                    ->update(['status'=>3,'update_by'=>Auth::user()->id]);
                }
                else{
                    $ownProduct->status = 3;
                    $ownProduct->save();
                }
            } 
            else{
                $transfer->delete();
                // Update Product_archive Table
                DB::table('product_archive')
                ->where('id',$r['barcode_id'])
                ->update(['status'=>3,'update_by'=>Auth::user()->id]);
                
            }
            event(new StockUpdateEvent($r['code']));
            // $ecom_stock = (int)Productarchive::where(['code'=>$r['code'],'status'=>3])->count();
            // if($ecom_stock <= 1){
            //     event(new StockUpdateEvent($r['code'])); 
            //     //event(new StockIsZeroEvent($item['code']));
            // }
            
            $this->updateProductStock($r['code']);
                
        });
        $this->insertOrderLog($r['orderno'],'Item Removed','Item #'.$r['barcode'].' Removed By '.Auth::user()->username);
        return ['status'=>'ok','message'=>'Item Deleted Successfully'];
    }

    public function itemupdate(Request $r){
    DB::transaction(function () use ($r) {
        DB::table('orders')
                    ->where('order_no',$r['order_no'])
                    ->update(['items'=>$r['itemList'],'sub_total'=>$r['subtotal'],'discount'=>$r['discamount'],
                    'vat'=>$r['vatamount'],'delivery_fee'=>$r['deliveryfee'],'net_payable'=>$r['netpayable'],
                    'remarks'=>$r['orderremarks'],'delivery_channel'=>$r['delivery_channel'],
                    'pathao_pickup'=>$r['pathao_pickup'],'update_by'=>Auth::user()->id]);
        if($r['newItem']!=''){
            $this->insertOrderLog($r['order_no'],'Product Added','Product '.$r['newItem'].' added By '.Auth::user()->username);
        }
        // $ordr = Order::where('order_no',$r['order_no'])->first();
        // $seller_id = $ordr->outlet;      
        foreach( $r['itemList']  as $key=>$item){
            
            //$arc = Productarchive::where(['id'=>$item['barcode_id'],'outlet_id'=>$r['seller_outlet'], 'status'=>3])->first();
            $parts = explode('-', $r['order_no']);
            $r['seller_outlet'] =  (int)$parts[4];
            
            if($item['outlet_id'] != $r['seller_outlet']){

                $transfer = OrderTransfer::where(['order_no'=>$item['orderno'],'barcode_init'=>$item['barcode']])->first();
                if ($transfer === null) {
                    // Not Found
                    // Insert Order_transfer Table
                    $orderTransfer = new OrderTransfer();
                    $orderTransfer->fy = date("Y");
                    $orderTransfer->date = date("Y-m-d");
                    $orderTransfer->order_no = $item['orderno'];
                    $orderTransfer->product_code = $item['code'];
                    $orderTransfer->barcode_init = $item['barcode'];
                    $orderTransfer->seller_outlet = $r['seller_outlet'];
                    $orderTransfer->request_outlet = $item['outlet_id'];
                    $orderTransfer->entry_by = Auth::user()->id;
                    $orderTransfer->save();

                    // Update Product_archive Table
                    DB::table('product_archive')
                    ->where('id',$item['barcode_id'])
                    ->update(['status'=>71,'update_by'=>Auth::user()->id]);

                }

            }
            else{
                // Update Product_archive Table
                DB::table('product_archive')
                ->where('id',$item['barcode_id'])
                ->update(['status'=>71,'update_by'=>Auth::user()->id]);
            }
            event(new StockUpdateEvent($item['code']));
            // $current_stock = $this->updateProductStock($item['code']);
            // if($current_stock <= 1){
            //     event(new StockUpdateEvent($item['code']));
            //     // Create Event
            //     //$codes = (explode("-",$item['code']));
            //     //$code = $codes[0].'-'.$codes[1];
            //      //event(new StockIsZeroEvent($item['code']));
            // }
            //app('App\Http\Controllers\api\v1\ecommerce\EcommerceController')->update_variation($item['code']);
            
        }
    });

    return ['status'=>'ok','message'=>'Order Updated Successfully'];
    }

    public function updateProductStock($code){
        $stock = (int)Productarchive::where(['code'=>$code,'status'=>3])->count();
        DB::table('products')
                    ->where('code',$code)
                    ->update(['current_stock'=>$stock]);
        return $stock;

    }

    public function getPendingTransfers($outlet){
        $id = (int)$outlet;
        return OrderTransfer::where(['request_outlet'=>$id])
                ->whereDate('entry_at', '>', Carbon::now()->subDays(365))
                ->orderBy('entry_at','desc')
                ->get();
    }
    
    public function getAllReceiveTransfers($outlet){
        $id = (int)$outlet;
        return 
        OrderTransfer::where([ ['seller_outlet', '=' ,$id],['status', '>' ,1],])
                    ->whereDate('entry_at', '>', Carbon::now()->subDays(365))
                    ->orderBy('entry_at','desc')
                    ->get();
    }

    public function receiveTransfer(Request $r){
        $ret_val = DB::transaction(function () use ($r) {
            $outlet_id = (int)$r['outlet_id'];
            $outlet_name = $r['outlet_name'];
            $barcode = $r['barcode'];

            // UPdate product archive
            $archive = Productarchive::where(['barcode'=>$barcode])->first();
            $old_outlet = $archive->outlet_id;
            $archive->outlet_id = $outlet_id;
            $archive->outlet_name = $outlet_name;
            $archive->save();

            $product_id = $archive->product_id;

            //Decrement old outlet stock
            DB::table('stock')
            ->where(['product'=>$product_id,'outlet'=>$old_outlet])
            ->increment('quantity', -1);
            //Increment New Outlet Stock
            DB::table('stock')
            ->where(['product'=>$product_id,'outlet'=>$outlet_id])
            ->increment('quantity', 1);
           

            // Update order transfer
            $transfer = OrderTransfer::where(['order_no'=>$r['orderno'],'barcode_final'=>$r['barcode']])->first();
            $transfer->status = 3;
            $transfer->save();

            $this->insertOrderLog($r['orderno'],'Product Received','Product '.$r['barcode'].' received By '.Auth::user()->username).' at '.$outlet_name;

            $ret['status'] = 'success';
            $ret['message'] = 'Stock Received';
            $ret['message2'] = 'Thank You';
            return $ret;
        });

        return $ret_val;
    }

    public function confirmTransfer(Request $r){

    $ret_val = DB::transaction(function () use ($r) {
            $outlet = (int)$r['outlet'];
            $orderno = $r['orderno'];
            $barcode_init = $r['barcode_init'];
            $barcode_final = $r['barcode_final'];
            $code = $r['code'];

            $archivestatus = 71;
            if($barcode_init!=$barcode_final) $archivestatus = 3;

            $order = OrderTransfer::where(['request_outlet'=>$outlet,'order_no'=>$orderno,'barcode_init'=>$barcode_init,'status'=>1])->first();
            $product_archive = Productarchive::where(['outlet_id'=>$outlet,'code'=>$code,'barcode'=>$barcode_final,'status'=>$archivestatus])->first();
            $ret = [];

            if(($order === null) || ($product_archive === null)){
                $ret['status'] = 'error';
                $ret['message'] = 'Impossible Transfer';
                $ret['message2'] = 'Please Check Order Properly';
            }
            else{
                $order->barcode_final = $barcode_final;
                $order->status = 2;
                $order->confirmed_at = now();
                $order->save();

                

                // New Barcode Is Different
                if($archivestatus==3){
                    // Update Status of New Barcode
                    $product_archive->status = 71;
                    $product_archive->save();

                    // Update status of Old Barcode
                    $p1 = Productarchive::where(['barcode'=>$barcode_init])->first();
                    $p1->status = 3;
                    $p1->save();

                }


                // Update Order Json Items
                $p = Productarchive::where(['barcode'=>$barcode_final])->first();
                $ord = Order::where('order_no',$orderno)->first();
                $seller = $ord->outlet;
                $items = $ord->items;
                $fitems = $items;
                foreach ($items as $i => $v) {
                    if($v['barcode'] ==  $barcode_init){
                        $fitems[$i]['barcode'] = $barcode_final;
                        $fitems[$i]['barcode_id'] = $p->id;
                        $fitems[$i]['outlet_id'] = $seller;
                        $fitems[$i]['outlet_name'] = $p->outlet_name;
                    }
                }
                $ord->items = $fitems;
                $ord->save();

                $ret['status'] = 'success';
                $ret['message'] = 'Transfer Confirmed';
                $ret['message2'] = 'Thank You';

                $this->insertOrderLog($r['orderno'],'Product Transferred','Product '.$barcode_final.' Transferred By '.Auth::user()->username);
        
            }
            return $ret;
        });

        return $ret_val;
    }

    public function getOutletOrders($outlet,$fromDate,$toDate){
        $id = (int)$outlet;
        
        if(Auth::user()->group_id < 3){ // For Top management +
            return 
            Order::whereBetween('date', [$fromDate, $toDate])
            ->orderBy('entry_at','desc')
            ->get();
        }
        else{ // For Individual
            return Order::where('outlet',$id)
            ->whereBetween('date', [$fromDate, $toDate])
            ->orderBy('entry_at','desc')
            ->get();
        }
    }

    public function getDueOrders($outlet,$fromDate,$toDate){
        $id = (int)$outlet;
        return 
                Order::where('outlet',$id)
                ->whereRaw('orders.paid != orders.net_payable')
                ->whereBetween('date', [$fromDate, $toDate])
                ->orderBy('entry_at','desc')
                ->get();
    }

    public function printThreeInchOrder($order){
        ini_set('memory_limit', '128M');
        $data['order'] = Order::where('order_no','=', $order)->first();
        $data['payment'] = Payment::where('order_no','=', $order)->first();
        $data['customer'] = Customer::where('id','=', $data['order']->customer)->first();
        $data['outlet'] = Outlet::where('id','=',$data['order']->outlet)->first();
        $data['creator'] = User::where('id','=',$data['order']->entry_by)->first();

        $pdf = PDF::loadView('order3inch', $data,[],[
            'format' => 'A4',
            'default_font' => 'FreeSerif',
            'mode' => 'utf-8',
            'margin_left' => '2',
            'margin_right' => '2',
            'margin_top' => '2',
            'margin_bottom' => '2'

          ]);
        return $pdf->stream($data['order']->order_no.'-sell-invoice.pdf');
    }

    public function printA4Order($order){
        ini_set('memory_limit', '128M');
        $data['order'] = Order::where('order_no','=', $order)->first();
        $data['packagings'] = Packaging::where('order_no','=', $order)->where('status','!=','Discard')->orderby('entry_at','DESC')->first();
        $data['payments'] = Payment::where('order_no','=', $order)
                            ->with([
                                'method'=> function($query) {
                                    $query->select('id','name');
                                }
                            ])->get();
                            //dd($data['payments'][0]->method->name);
        $data['customer'] = Customer::where('id','=', $data['order']->customer)->first();
        $data['outlet'] = Outlet::where('id','=',$data['order']->outlet)->first();
        $data['creator'] = User::where('id','=',$data['order']->entry_by)->first();
        $data['exchanged'] = Exchange::where('order_no','=', $order)->where('status','=','Initiated')
        ->with([
            'delivery_channel'=> function($query) {
                $query->select('id','name','rate');
            },  
        ])->orderBy('entry_at', 'desc')->get();
        //dd($data['exchanged'][0]->items[0]['newed']);
        $data['returned'] = false;
        $data['returned_total'] = 0;

        foreach ($data['order']->items as $key => $value) {
            if($value['returned'])
            {
                $data['returned_total']+=$value['price'];
                $data['returned'] = true;
            }
        }


        $result = Builder::create()
                    ->writer(new PngWriter())
                    ->writerOptions([])
                    ->data($order)
                    ->encoding(new Encoding('UTF-8'))
                    ->errorCorrectionLevel(new ErrorCorrectionLevelHigh())
                    ->size(150)
                    ->margin(10)
                    ->roundBlockSizeMode(new RoundBlockSizeModeMargin())
                    // ->logoPath(__DIR__.'/assets/symfony.png')
                    // ->labelText('This is the label')
                    // ->labelFont(new NotoSans(20))
                    // ->labelAlignment(new LabelAlignmentCenter())
                    ->build();
                    header('Content-Type: '.$result->getMimeType());
        $result->saveToFile('order_doc/'.$order.'.png');
        
        $pdf = PDF::loadView('ordera4', $data,[],[
            'format' => 'A4',
            'default_font' => 'FreeSerif',
            'mode' => 'utf-8',
            'margin_left' => '10',
            'margin_right' => '10',
            'margin_top' => '10',
            'margin_bottom' => '10'
          ]);
//           $pdf->SetHTMLFooter('
// <table width="100%">
//     <tr>
//         <td width="33%">{DATE j-m-Y}</td>
//         <td width="33%" align="center">{PAGENO}/{nbpg}</td>
//         <td width="33%" style="text-align: right;">My document</td>
//     </tr>
// </table>');
        return $pdf->stream($data['order']->order_no.'-invoice.pdf');
                    
    }
    


}
