<?php

namespace App\Http\Controllers\api\v1\expense;

use App\Http\Controllers\Controller;
use App\Models\Balance;
use App\Models\Balance_method;
use App\Models\Customer;
use App\Models\Expense;
use App\Models\Expense_sector;
use App\Models\Order;
use App\Models\Outlet;
use App\Models\P_Employee;
use App\Models\P_Loan;
use App\Models\P_LoanPaid;
use App\Models\P_SalaryPosting;
use App\Models\Production;
use App\Models\Supplier;
use App\Models\Supplierbill;
use App\Models\SupplierBillPay;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class ExpenseController extends Controller
{   
    public function query($from='',$to=''){
        if($from=='' || $to==''){
            $from = date("Y-m-01");     
            $to = date("Y-m-d", strtotime("+1 day"));
        }
        $group = Auth::user()->group_id;
        $outlet = Auth::user()->outlet;
        $r['sectors'] = null;
        $r['methods'] = null;
        if($group==1 || $group==2){
            $r['outlets'] = Outlet::where('id','!=',0)->get();
            $r['employees'] = P_Employee::all();
            $r['loans'] = P_Loan::whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();

            $r['billpays'] = SupplierBillPay::whereBetween('entry_at', [$from, $to])
            ->with([
                'supplier'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();

            $r['bills'] = Supplierbill::whereBetween('entry_at', [$from, $to])
            ->with([
                'user'=> function($query) {
                    $query->select('id','username');
                }, 
                'supplier'=> function($query) {
                    $query->select('id','name');
                },  
            ])->orderBy('entry_at','desc')->get();

            $r['accounts'] =  Balance::where('balance_method','!=',5)
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();
            
            $r['approvals'] = Expense::where('status','Pending')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'sector'=> function($query) {
                        $query->select('id','name');
                    },
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    },
                    'entry_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                    'approved_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                
                ->orderBy('entry_at','desc')->get();

            $r['expenses'] = Expense::whereBetween('entry_at', [$from, $to])
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    },
                    'sector'=> function($query) {
                        $query->select('id','name');
                    },
                    'entry_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                    'approved_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                ->orderBy('entry_at','desc')->get();
        }
        else{
            $r['outlets'] = Outlet::where('id',$outlet)->get();
            $r['employees'] = P_Employee::where('outlet',$outlet)->get();
            $r['loans'] = P_Loan::where('outlet',$outlet)->whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();
            $r['billpays'] = SupplierBillPay::where('outlet',$outlet)->whereBetween('entry_at', [$from, $to])
            ->with([
                'supplier'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();
            $r['accounts'] =  Balance::where('balance_method','!=',5)->where('outlet',$outlet)
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();

            $r['expenses'] = Expense::where('outlet',$outlet)->whereBetween('entry_at', [$from, $to])
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    },
                    'sector'=> function($query) {
                        $query->select('id','name');
                    },
                    'entry_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                    'approved_by'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                ->orderBy('entry_at','desc')->get();
        }

        $r['sectors'] = Expense_sector::all();
        $r['suppliers'] = Supplier::all();
        
        
        return $r;
        

    }

    public function approve(Request $request){
        DB::transaction(function () use ($request) {
            $expense = Expense::find($request->id);
            $from_balance = $expense->from_balance;
            $from = Balance::find($from_balance);
            $acc_outlet = $from->outlet;
            if($request->type===true){

                $b = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
                $from = Balance::find($b->id);
                $from->decrement('amount',$expense->amount);
                $from->save();

                $expense->status = 'Approved';
                $expense->approved_by = Auth::user()->id;
                $expense->approved_at = now();
                $expense->save();

                //Loan Deduct
                if($expense->receipt_no){
                    $str = substr($expense->receipt_no,0,1);
                    if($str=='P'){
                        $salaryposting = P_SalaryPosting ::where('posting_no',$expense->receipt_no)->first();
                        $emp = $salaryposting->items['employee'];
                        // Loan and Remaining Vacation Adjust
                        if($emp['type']=='production'){
                            Production::where([
                                ['yearmonth', '=', null],
                                ['emp_id', '=', $emp['id']]
                            ])->update(['yearmonth'=>$salaryposting->yearmonth]);
                            //Production::where('yearmonth','=',null))->where('emp_id',$eid)->update(['yearmonth'=>$request['yearmonth']]);
                            if($salaryposting->items['deductions'][0]['amount'] > 0){
                                $this->loan_deduct($salaryposting->yearmonth,$salaryposting->outlet,$salaryposting->emp_id,$salaryposting->items['deductions'][0]['amount']);
                            }
                        }
                        else{
                            $employee = P_Employee::where('id',$salaryposting->emp_id)->first();
                            $employee->vacation_remains = (int)$salaryposting->items['deductions'][0]['vac_remains'];
                            $employee->save();
                            if($salaryposting->items['deductions'][2]['amount'] > 0){
                                $this->loan_deduct($salaryposting->yearmonth,$salaryposting->outlet,$salaryposting->emp_id,$salaryposting->items['deductions'][2]['amount']);
                            }
                        }
                    }
                    else if($str=='S'){
                        $billpay = SupplierBillPay::where('payment_no',$expense->receipt_no)->first();
                        $supplier = Supplier::find($billpay->supplier);
                        $supplier->decrement('dues',$billpay->amount);
                        $supplier->save();
                        //$billpay->delete();
                    }
                }

            }
            else{

                $b = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
                $from = Balance::find($b->id);
                $from->decrement('amount',$expense->amount);
                $from->save();

                $b = Balance::where('outlet',$acc_outlet)->where('balance_method',$expense->method)->first();
                $from = Balance::find($b->id);
                $from->increment('amount',$expense->amount);
                $from->save();

                $expense->status = 'Canceled';
                $expense->approved_by = Auth::user()->id;
                $expense->approved_at = now();
                $expense->save();
                if($expense->receipt_no){
                    $str = substr($expense->receipt_no,0,1);
                    if($str=='L'){
                        $loan = P_Loan::where('loan_no',$expense->receipt_no)->first();
                        $loan->delete();
                    }
                    if($str=='S'){
                        $billpay = SupplierBillPay::where('payment_no',$expense->receipt_no)->first();
                        $billpay->delete();
                    }
                    if($str=='P'){
                        $salaryposting = P_SalaryPosting ::where('posting_no',$expense->receipt_no)->first();
                        $salaryposting->delete();
                    }
                }
                
            }
            
        });

        return $this->query();
    }

    public function initentry(Request $request){
        DB::transaction(function () use ($request) {
            //Expense status
            $expense = new Expense();
            $expense->expense_sector = $request->expense_sector;
            $expense->outlet = $request->outlet;
            $expense->method = $request->method;
            $expense->status = 'Pending';
            $expense->from_balance = $request->from_balance_id;
            $expense->amount = $request->amount;
            $expense->remarks = $request->remarks;
            $expense->entry_by = Auth::user()->id;
            $expense->save();

            //decrement from balance
            $from = Balance::find($request->from_balance_id);
            $from->decrement('amount',$request->amount);
            $acc_outlet = $from->outlet;
            $from->save();
            //To frozen balance
            $to = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
            if($to){
                $to_frozen = Balance::find($to->id);
                $to_frozen->increment('amount',$request->amount);
                $to_frozen->save();
            }
            else{
                $bal = new Balance();
                $bal->outlet = $acc_outlet;
                $bal->amount = $request->amount;
                $bal->balance_method = 5;
                $bal->method_name = 'Frozen Balance';
                $bal->entry_by = 1;
                $bal->save();
            }
        });

        return $this->query();
    }
    private function loan_deduct($ymon, $outlet,$eid,$amount){
        $lastLoan = P_Loan::where('emp_id',$eid)->where('outlet',$outlet)->orderBy('entry_at','desc')->first();;
        if($lastLoan){
            $loanPaid = new P_LoanPaid();
            $loanPaid->outlet = $outlet;
            $loanPaid->emp_id = $eid;
            $loanPaid->amount = $amount;
            $loanPaid->loan_no = $lastLoan->loan_no;
            $loanPaid->remarks = 'Paid From Salary of '.$ymon;
            $loanPaid->save();
            //$loan = P_Loan::find($lastLoan->id);
            P_Loan::where('id',$lastLoan->id)->increment('paid', $amount);
        }
    }
    private function _getLoanNo($eid,$outlet){
        $today = date("Y-m-d");
        $test_inv = 'L-'.$today.'-'.$outlet.'-'.$eid;
        $statements = P_Loan::where('loan_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    private function _getBillNo($supplier){
        $today = date("Y-m-d");
        $test_inv = 'SB-'.$today.'-'.$supplier;
        $statements = Supplierbill::where('bill_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    private function _getBillPayNo($supplier,$outlet){
        $today = date("Y-m-d");
        $test_inv = 'SBP-'.$today.'-'.$outlet.'-'.$supplier;
        $statements = SupplierBillPay::where('payment_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    public function loanentry(Request $request){
        DB::transaction(function () use ($request) {
            $emp = P_Employee::where('id',$request->eid)->first();
            // Loan Entry
            $loan = new P_Loan();
            $loan->outlet = $request->outlet;
            $loan->emp_id = $request->eid;
            $loan->loan_no = $this->_getLoanNo($request->eid,$request->outlet);
            $loan->amount = $request->amount;
            $loan->paid = 0;
            $loan->remarks = $emp->name.'-'.$request->remarks;
            $loan->entry_by = Auth::user()->id;
            $loan->save();
            //Expense Entry
            $expense = new Expense();
            $expense->expense_sector = 98;
            $expense->outlet = $request->outlet;
            $expense->method = $request->method;
            $expense->receipt_no = $loan->loan_no;
            $expense->status = 'Pending';
            $expense->from_balance = $request->from_balance_id;
            $expense->amount = $request->amount;
            $expense->remarks = $emp->name.'-'.$request->remarks;
            $expense->entry_by = Auth::user()->id;
            $expense->save();

            //decrement from balance
            $from = Balance::find($request->from_balance_id);
            $from->decrement('amount',$request->amount);
            $acc_outlet = $from->outlet;
            $from->save();
            //To frozen balance
            $to = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
            if($to){
                $to_frozen = Balance::find($to->id);
                $to_frozen->increment('amount',$request->amount);
                $to_frozen->save();
            }
            else{
                $bal = new Balance();
                $bal->outlet = $acc_outlet;
                $bal->amount = $request->amount;
                $bal->balance_method = 5;
                $bal->method_name = 'Frozen Balance';
                $bal->entry_by = 1;
                $bal->save();
            }
        });

        return $this->query();
    }
    public function billpay(Request $request){
        DB::transaction(function () use ($request) {
            //Bill Pay
            $billpay = new SupplierBillPay();
            $billpay->outlet = $request->outlet;
            $billpay->supplier = $request->supplier;
            $billpay->payment_no = $this->_getBillPayNo($request->supplier,$request->outlet);
            $billpay->amount = $request->amount;
            $billpay->remarks = $request->remarks;
            $billpay->entry_by = Auth::user()->id;
            $billpay->save();
            //Expense Entry
            $expense = new Expense();
            $expense->expense_sector = 97;
            $expense->outlet = $request->outlet;
            $expense->method = $request->method;
            $expense->receipt_no = $billpay->payment_no;
            $expense->status = 'Pending';
            $expense->from_balance = $request->from_balance_id;
            $expense->amount = $request->amount;
            $expense->remarks = $request->remarks;
            $expense->entry_by = Auth::user()->id;
            $expense->save();

            //decrement from balance
            $from = Balance::find($request->from_balance_id);
            $from->decrement('amount',$request->amount);
            $acc_outlet = $from->outlet;
            $from->save();
            //To frozen balance
            $to = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
            if($to){
                $to_frozen = Balance::find($to->id);
                $to_frozen->increment('amount',$request->amount);
                $to_frozen->save();
            }
            else{
                $bal = new Balance();
                $bal->outlet = $acc_outlet;
                $bal->amount = $request->amount;
                $bal->balance_method = 5;
                $bal->method_name = 'Frozen Balance';
                $bal->entry_by = 1;
                $bal->save();
            }
        });

        return $this->query();
    }
    public function billentry(Request $request){
        DB::transaction(function () use ($request) {
            // Bill Entry
            $bill = new Supplierbill();
            $bill->supplier = $request->supplier;
            $bill->bill_no = $this->_getBillNo($request->supplier);
            $bill->amount = $request->amount;
            $bill->remarks = $request->remarks;
            $bill->entry_by = Auth::user()->id;
            $bill->save();

            $supplier = Supplier::find($request->supplier);
            $supplier->increment('dues',$request->amount);
            $supplier->save();
        });

        return $this->query();
    }

    public function entry(Request $r){

        DB::transaction(function () use ($r) {
            //Order Info
            $order = Order::where('order_no',$r['order_no'])->first();
            $outlet = $order->outlet;
            $balance = Balance::where('outlet',$outlet)->where('balance_method',1)->first();
            
            //Expense status
            $expense = new Expense();
            $expense->expense_sector = 19; //order expense
            $expense->outlet = $outlet;
            $expense->method = 1;
            $expense->status = 'Pending';
            $expense->receipt_no = $r['order_no'];
            $expense->from_balance = $balance->id;
            $expense->amount = $r['amount'];
            $expense->remarks = 'Expense of '.$r['order_no'].' -- '.$r['remarks'];
            $expense->entry_by = Auth::user()->id;
            $expense->save();

            //decrement from balance
            $balance->decrement('amount',$r['amount']);
            $balance->save();
            //To frozen balance
            $to_frozen = Balance::where('outlet',$outlet)->where('balance_method',5)->first();
            $to_frozen->increment('amount',$r['amount']);
            $to_frozen->save();
        });

        // $expense = new Expense();
        // $expense->expense_sector = $r['sector_id'];
        // //$expense->outlet = 0;
        // //$expense->method = 0;
        // //$expense->from_balance = 0;
        // $expense->receipt_no = $r['order_no'];
        // $expense->amount = $r['amount'];
        // $expense->status = 'Pending';
        // $expense->remarks = $r['remarks'];
        // $expense->save();

        return [
            'status'=>'success',
            'title'=>'Expense Added',
            "message" => 'Expense Successfully Inserted For This Order',
        ];
    }
}
