<?php

namespace App\Http\Controllers\api\v1\common;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;

use App\Models\Customer;
use App\Models\Order;
use App\Models\Sell;

class CustomerController extends Controller
{
    public function getCustomers($from='',$to=''){
        if($from=='' || $to==''){
            $from = date("Y-m-01");     
            $to = date("Y-m-d", strtotime("+1 day"));
        }
        $r['customers'] = Customer::whereBetween('entry_at', [$from, $to])->orderBy('entry_at','desc')->get();
        return $r;

    }
    public function getDetails($id){
        $r['pos'] = Sell::where('customer',$id)->select(DB::raw('invoice_no,payable,due'))->get();
        $r['order'] = Order::where('customer',$id)->select(DB::raw('order_no,net_payable,paid'))->get();
        return $r;
    }
    
    public function index(){
        return Customer::all();
    }
    public function import(){
        $filename = storage_path('/app/c.csv');
        $file = fopen($filename, "r");
        $all_data = array();
        $i=1;
        while ( ($data = fgetcsv($file, 200, ",")) !==FALSE ) {
            echo $i.'---'.$data[0].'---'.$data[1].'---'.$data[2].'<br/>';
            //$arr = ['name'=>$data[0],'mobile'=>'0'.$data[1],'address'=>$data[2]];
            $customer = new Customer();
            $customer->name = $data[0];
            $customer->mobile = '0'.$data[1];
            $customer->address = $data[2];
            $customer->deliveryaddress = 'Same';
            $customer->save();
            //array_push($all_data,$arr);
            $i++;
        }
        //print_r($all_data);

        // $file_n = Storage::url('data.csv');
        // $file = fopen($file_n, "r");
        // $all_data = array();
        // while ( ($data = fgetcsv($file, 200, ",")) !==FALSE {
        //     $name = $data[0];
        //     $city = $data[1];
        //     $all_data = $name. " ".$city;

        //     array_push($array, $all_data);
        // }
        // fclose($file);
    }

    public function create(Request $c){
        $customer = new Customer();
        $customer->mobile = $c['cmobile'];
        $customer->name = $c['cname'];
        $customer->address = $c['caddress'];
        $customer->dues = 0;
        $customer->save();
        
        return Customer::all();
        //$ret = ['0'=>$customer];
        //return $ret;

    }

    public function customerfrommobile($mobile){
        return Customer::where('mobile',$mobile)->first();
    }

    public function idfrommobile($mobile){
        $customer = Customer::where('mobile',$mobile)->first();
        if (is_null($customer)) {
            $customer = new Customer();
            $customer->mobile = $mobile;
            $customer->dues = 0;
            $customer->save();
            return $customer;
        }
        return $customer;
    }

    public function getCustomerScore($cid){
        $customer = (int)$cid;
        $data['score'] =
                DB::table('orders')
                 ->select('status as statusno', DB::raw('count(id) as counter'),DB::raw('count(id) as counter'))
                 ->where('customer', '=', $customer)
                 ->groupBy('status')
                 ->orderBy('status')
                 ->get();
        $data['orders'] =
                DB::table('orders')
                ->select('id','order_no', 'net_payable','status','paid','date')
                ->where('customer', '=', $customer)
                ->orderBy('entry_at','desc')
                ->get();
        return $data;
    }

    public function updateCustomer(Request $c){
        DB::table('customers')
                        ->where('id',$c['id'])
                        ->update(['mobile'=>$c['mobile'],'name'=>$c['name'],'address'=>$c['address'],
                        'deliveryaddress'=>$c['delivery'],'email'=>$c['email'],'update_by'=>Auth::user()->id]);
        return ['status'=>'ok','message'=>'Customer Updated Successfully'];
    }
    
    public function allCustomer()
{
    $headers = ['Name', 'Mobile', 'Entry'];
    
    // CSV response headers
    $responseHeaders = [
        'Content-Type' => 'text/csv',
        'Content-Disposition' => 'attachment; filename="customer.csv"',
        'Pragma' => 'no-cache',
        'Cache-Control' => 'must-revalidate, post-check=0, pre-check=0',
        'Expires' => '0',
    ];

    $callback = function () use ($headers) {
        $file = fopen('php://output', 'w');

        // Add the CSV header row
        fputcsv($file, $headers);

        // Process data in chunks to optimize memory usage
        Customer::select('name', 'mobile', 'entry_at')
            ->groupBy('mobile')
            ->orderBy('entry_at', 'desc')
            ->chunk(1000, function ($customers) use ($file) {
                foreach ($customers as $customer) {
                    // Add each row to the CSV
                    fputcsv($file, [
                        $customer->name,
                        $customer->mobile,
                        $customer->entry_at,
                    ]);
                }
            });

        fclose($file);
    };

    // Return the response as a streamed CSV download
    return response()->stream($callback, 200, $responseHeaders);
}

    
    // public function allCustomer(){
    //     $headers = ['Name', 'Mobile','Entry'];
    //     $all = Customer::select('name', 'mobile','entry_at')->distinct('mobile')->orderBy('entry_at', 'desc')->get();
        
    //     $customers = $all->map(function ($c) {
    //         return array_values($c->toArray());
    //     });

    //     $callback = function () use ($headers, $customers) {
    //         $file = fopen('php://output', 'w');
            
    //         // Add the headers
    //         fputcsv($file, $headers);

    //         // Add the data
    //         foreach ($customers as $row) {
    //             fputcsv($file, $row);
    //         }

    //         fclose($file);
    //     };
        
    //     // Return the response as a CSV download
    //     return Response::stream($callback, 200, [
    //         'Content-Type' => 'text/csv',
    //         'Content-Disposition' => 'attachment; filename="customer.csv"',
    //     ]);
        
        
    // }
}
