<?php

namespace App\Http\Controllers\api\v1\common;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Support\Facades\Auth;

use App\Models\Productarchive;
use App\Models\Sell;
use Carbon\Carbon;
use PhpParser\Node\Stmt\Foreach_;
use Illuminate\Http\Request;

class BarcodeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getBarcodesofProduct($pid){
        return Productarchive::where(['product_id' => $pid, 'status' => 1])->get();
    }
    public function getBarcodeDetails($barcode)
    {
        return Productarchive::where(['barcode' => $barcode, 'status' => 1])->get();
    }

    public function barcodeofoutlet($outlet,$barcode,$status){
        return Productarchive::where(['barcode' => $barcode, 'status' => $status,'outlet_id'=>$outlet])->get();
    }

    public function getavailableOldbarcode2(Request $request){
        $skip = (int)$request['scount'];
        $ptype = (int)$request['ptype'];
        $oid = (int) $request['outlet_id'];
        if($oid==0){
            if($ptype==0) return Productarchive::where(['code'=>$request['barcode'],'status'=>1 ])->skip($skip)->first();
            else return Productarchive::where(['barcode'=>$request['barcode'],'status'=>1 ])->first();
        }
        else{
            if($ptype==0) return Productarchive::where(['code'=>$request['barcode'],'outlet_id'=>$request['outlet_id'],'status'=>3 ])->skip($skip)->first();
            else return Productarchive::where(['barcode'=>$request['barcode'],'outlet_id'=>$request['outlet_id'],'status'=>3 ])->first();
        }
    }
    
    // public function getAvailableOldBarcode2(Request $request)
    // {
    //     $skip = $request->input('scount', 0);
    //     $ptype = $request->input('ptype', 0);
    //     $oid = $request->input('outlet_id', 0);
    
    //     $query = Productarchive::where('code', $request->barcode)
    //         ->where('status', $ptype ? 3 : 1);
    
    //     if ($oid) {
    //         $query->where('outlet_id', $oid);
    //     }
    
    //     if ($ptype == 0) {
    //         $query->skip($skip);
    //     }
        
    //     return $query->first();
    // }

    public function getArchive(Request $request)
    {
        return Productarchive::where(['barcode'=>$request['barcode'],'status'=>4 ])->first();
    }
    private function getOrdernoFromBarcode($barcode){
        $twomonth = Carbon::now()->subMonth(2);
        $today = Carbon::now();
        $orders = Order::whereBetween('entry_at',[$twomonth,$today])->orderBy('entry_at','desc')->get();
        //return $orders;
        $order_no = '';
        foreach ($orders as $key => $order) {
            $found = false;
            foreach ($order->items as $k => $item) {
                if($item['barcode']==$barcode) $found = true;
            }
            if($found){
                $order_no = $order->order_no;
                break;
            }
        }
        return $order_no;
    }
    public function getReturnBarcode(Request $request)
    {
        $arc = Productarchive::where(['barcode'=>$request['barcode'],'status'=>4 ])->first();
        if($arc){ // Found In POS
            $sell = Sell::where('invoice_no',$arc->sell_statement)->first();
            return ['barcode'=>$arc,'sell'=>$sell,'order'=>null];
        }
        else{ // Search In Order
            $barcode = $request['barcode'];
            $arcO = Productarchive::where(['barcode'=>$request['barcode'],'status'=>71 ])->first();
            $order_no = $this->getOrdernoFromBarcode($barcode);
            $order = Order::where('order_no',$order_no)->first();
            return ['barcode'=>$arcO,'sell'=>null,'order'=>$order];
        }
        
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
