<?php

namespace App\Http\Controllers\api\v1\callcenter;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use App\Models\Product;
use App\Models\Productarchive;
use App\Models\Outlet;
use App\Models\ProductArchiveDecimalPricing;

use Automattic\WooCommerce\Client;

// use Automattic\WooCommerce\HttpClient\HttpClientException;
use Illuminate\Support\Facades\Log;


class ProductController extends Controller
{

    public function barcodes(Request $r){
        $id = $r['outlet_id'];
        $code = $r['code'];
        return Productarchive::where([['code','=',$r['code']], ['outlet_id','=',$r['outlet_id']], ['status','=',3] ])->get();
    }
   
    public function base_details(Request $r){
        $url = config('woocommerce.store_url');
        $key = config('woocommerce.consumer_key');
        $secret = config('woocommerce.consumer_secret');
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => true];
        $client = new Client($url,$key,$secret, $version);

        $bcode = $r['code'];
        //Base Product
        $tmpHead = Product::where([['code','=',$bcode]])->first();
        //return ['status'=>'200','data'=>$tmpHead];
        
        if($tmpHead ===null){
            $ret['head'] = Product::where([['code','like','%'.$bcode.'%']])->first();
            $ret['ecommerce'] = null;
        }
        else{
            // Get Head
            $ret['head'] = $tmpHead;
            
            $stts = $client->get('system_status');
            //return ['status'=>'200','data'=>$stts];
            //Get E-commerce
            //dd($client->get('products',['sku'=>$bcode]));
            $tmpEcom = $client->get('products',['sku'=>$bcode]);
            //$tmpEcom = $client->get('products');
            
            //return ['status'=>'200','data'=>$tmpEcom];
            
            if(isset($tmpEcom[0])){
                $ret['ecommerce']['base'] = $tmpEcom[0];
                $ret['ecommerce']['variations'] = $client->get('products/'.$tmpEcom[0]->id.'/variations');
            }
            else{
                $ret['ecommerce'] = null;
            }
        }

         $ret['variations'] = ProductArchiveDecimalPricing::where('code','LIKE',$bcode.'-%')->where('status','=',3)->groupBy('code')->get();

        // Outlet Wise Stock
        $ret['outlets'] = Outlet::select('id','name')->get();
        $ret['outletwise'] = ProductArchiveDecimalPricing::select('code','outlet_id','outlet_name', 'price',DB::raw('count(*) as barcodes'))
                            ->where('status', '=', 3)
                            ->where('code', 'like', $bcode.'-%')
                            ->groupBy('code','outlet_id')
                            ->orderBy('price')
                            ->get();
        return ['status'=>'200','data'=>$ret];
    }
    
    
// public function base_details(Request $r)
// {
//     // 1) Safer input read + quick validation
//     $bcode = $r->input('code');
//     if (!$bcode) {
//         return response()->json([
//             'status'  => 422,
//             'message' => 'Parameter "code" is required.'
//         ], 422);
//     }

//     // 2) Woo client (no nested env calls; enable query_string_auth to avoid stripped Authorization headers)
//     $client = new Client(
//         env('WOOCOMMERCE_STORE_URL', 'https://www.diganta.com.bd'),
//         env('WOOCOMMERCE_CONSUMER_KEY'),
//         env('WOOCOMMERCE_CONSUMER_SECRET'),
//         [
//             'version'           => 'wc/v3',
//             'timeout'           => 30,
//             'verify_ssl'        => true,
//             'query_string_auth' => true, // important if your server/CDN strips Authorization
//         ]
//     );

//     $ret = [];

//     // 3) Local base product
//     $tmpHead = Product::where('code', $bcode)->first();

//     if ($tmpHead === null) {
//         $ret['head'] = Product::where('code', 'like', '%'.$bcode.'%')->first();
//         $ret['ecommerce'] = null;
//     } else {
//         $ret['head'] = $tmpHead;

//         // 4) Woo lookups with error handling → avoids "woocommerce_rest_cannot_view" from crashing your API
//         try {
//             // products?sku=...
//             $tmpEcom = $client->get('products', ['sku' => $bcode]); // array of stdClass
//             if (!empty($tmpEcom) && isset($tmpEcom[0]->id)) {
//                 $ret['ecommerce']['base'] = $tmpEcom[0];

//                 // products/{id}/variations
//                 $ret['ecommerce']['variations'] = $client->get('products/'.$tmpEcom[0]->id.'/variations');
//             } else {
//                 $ret['ecommerce'] = null;
//             }
//         } catch (HttpClientException $e) {
//             // Log complete context; return a clean message
//             Log::error('WooCommerce API error', [
//                 'message'  => $e->getMessage(),
//                 'request'  => $e->getRequest(),
//                 'response' => $e->getResponse(),
//             ]);

//             // Still return partial local data; signal upstream trouble
//             return response()->json([
//                 'status'  => 502,
//                 'message' => 'WooCommerce API error: '.$e->getMessage(),
//                 'data'    => ['head' => $ret['head'] ?? null]
//             ], 502);
//         }
//     }

//     // 5) Variations — avoid ONLY_FULL_GROUP_BY issues; get distinct codes under this base code
//     $ret['variations'] = ProductArchiveDecimalPricing::where('code', 'LIKE', $bcode.'-%')
//         ->where('status', 3)
//         ->select('code')
//         ->distinct()
//         ->get();

//     // 6) Outlets
//     $ret['outlets'] = Outlet::select('id', 'name')->get();

//     // 7) Outlet-wise stock — include all non-aggregates in groupBy
//     $ret['outletwise'] = ProductArchiveDecimalPricing::select(
//             'code',
//             'outlet_id',
//             'outlet_name',
//             'price',
//             DB::raw('COUNT(*) AS barcodes')
//         )
//         ->where('status', 3)
//         ->where('code', 'like', $bcode.'-%')
//         ->groupBy('code', 'outlet_id', 'outlet_name', 'price')
//         ->orderBy('price')
//         ->get();

//     return response()->json(['status' => 200, 'data' => $ret]);
// }

    public function allproduct_details(Request $r){
        $bcode = $r['code'];
        //Base Product
        $ret['head'] = Product::where([['code','like','%'.$bcode.'%']])->first();
        if($ret['head']===null){
            return ['status'=>'404','title'=>'Not Found','message'=>'Product Code Not Exists'];
        }
        else{
            //['code','like','%'.$bcode.'%']
            $ret['totalProduction']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%']])->count();
            $ret['totalProduction']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%']])->get();
            
            $ret['inWarehouse']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',1]])->count();
            $ret['inWarehouse']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',1]])->get();

            $ret['transferChannel']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',2]])->count();
            $ret['transferChannel']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',2]])->get();

            $ret['sellAble']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',3]])->count();
            $ret['sellAble']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',3]])->get();

            $ret['orderChannel']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',71]])->count();
            $ret['orderChannel']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',71]])->get();

            $ret['sold']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',4]])->count();
            $ret['sold']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',4]])->get();

            $ret['damaged']['counter'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',99]])->count();
            $ret['damaged']['barcodes'] = ProductArchiveDecimalPricing::where([['code','like','%'.$bcode.'%'],['status', '=',99]])->get();

            // Outlet Wise Inventory
            $ret['statuswise'] = ProductArchiveDecimalPricing::select('status', DB::raw('count(*) as barcodes'))
                ->where([['code','like','%'.$bcode.'%']])
                ->groupBy('status')
                ->get();

            $ret['outletwise'] = ProductArchiveDecimalPricing::select('code','outlet_id','outlet_name', DB::raw('count(*) as barcodes'))
                ->where([['code','like','%'.$bcode.'%']])
                ->where('status','!=', 4)
                ->where('outlet_id','!=', 0)
                ->groupBy('outlet_id')
                ->orderBy('outlet_id')
                ->get();

            $ret['outlets'] = Outlet::select('id','name')->where('id','!=',0)->get();

            
            return ['status'=>'200','data'=>$ret];
        }
    }
    public function product_details(Request $r){
        $bcode = $r['code'];
        //Base Product
        $ret['head'] = Product::where('code',$bcode)->first();
        if($ret['head']===null){
            return ['status'=>'404','title'=>'Not Found','message'=>'Product Code Not Exists'];
        }
        else{
            $ret['totalProduction']['counter'] = ProductArchiveDecimalPricing::where('code', $bcode)->count();
            $ret['totalProduction']['barcodes'] = ProductArchiveDecimalPricing::where('code', $bcode)->get();
            
            $ret['inWarehouse']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',1]])->count();
            $ret['inWarehouse']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',1]])->get();

            $ret['transferChannel']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',2]])->count();
            $ret['transferChannel']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',2]])->get();

            $ret['sellAble']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',3]])->count();
            $ret['sellAble']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',3]])->get();

            $ret['orderChannel']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',71]])->count();
            $ret['orderChannel']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',71]])->get();

            $ret['sold']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',4]])->count();
            $ret['sold']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',4]])->get();

            $ret['damaged']['counter'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',99]])->count();
            $ret['damaged']['barcodes'] = ProductArchiveDecimalPricing::where([['code', '=' ,$bcode],['status', '=',99]])->get();

            // Outlet Wise Inventory
            $ret['statuswise'] = ProductArchiveDecimalPricing::select('status', DB::raw('count(*) as barcodes'))
                ->where('code', $bcode)
                ->groupBy('status')
                ->get();

            $ret['outletwise'] = ProductArchiveDecimalPricing::select('code','outlet_id','outlet_name', DB::raw('count(*) as barcodes'))
                ->where('code', $bcode)
                ->where('status','!=', 4)
                ->groupBy('outlet_id')
                ->orderBy('outlet_id')
                ->get();

            $ret['outlets'] = Outlet::select('id','name')->get();

            
            return ['status'=>'200','data'=>$ret];
        }
    }
}
