<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

//use App\User;

class LoginController extends Controller
{
    public function login(Request $request){
        //User::create(request(['Jasim Uddin', 'jasimmailid@gmail.com', '98899889aA']));
        // $user = \App\User::create([
        //     'name' => 'Jasim Uddin2',
        //     'email' => 'jasimmailid2@gmail.com',
        //     'password' => Hash::make('98899889aA'),
        // ]);
        $login = $request->validate([
            'email' => 'required|string',
            'password' => 'required|string'
        ]);

        if(!Auth::attempt($login)){
            return response([
                'message'=>'Invalid Credentials!'
            ]);
        }

        $accessToken = Auth::user()->createToken('authToken')->accessToken;
        
        return response(['user'=>Auth::user(),'access_tokken'=>$accessToken]);
    }

    public function userList(){
        return DB::table('tb_users')->select('id', 'email')->where('group_id','>',2)->get();
    }

    public function assigntooutlet(Request $r){
        DB::table('tb_users')
              ->where('id', $r['uid'])
              ->update(['outlet' => $r['oid']]);
        return(['status'=>'ok','message'=>'success']);
    }
}
